//	Draw4DHelpHowView.swift
//
//	© 2025 by Jeff Weeks
//	See TermsOfUse.txt

import SwiftUI


let helpHowHeaderColor = Color(.displayP3, red: 0.00, green: 0.75, blue: 0.50, opacity: 1.0)

struct Draw4DHelpHowView: View {

	@State var modifiedBackgroundColor = Color("Modified Background Color")

	var body: some View {

		ScrollView {
			VStack(alignment: .leading, spacing: 12) {
				
				Text("Intro-what")
					.font(.title2)
					.foregroundStyle(helpHowHeaderColor)
					.frame(maxWidth: .infinity, alignment: .center)
				
				Text("Intro-how")
					.font(.body)

				Draw4DHelpItem(
					icon: "Touch Modes/Add Points",
					what: "AddPoints-what",
					how: "AddPoints-how",
					note: nil)

				Draw4DHelpItem(
					icon: "Touch Modes/Add Edges",
					what: "AddEdges-what",
					how: "AddEdges-how",
					note: nil)

				Draw4DHelpItem(
					icon: "Touch Modes/Move Points",
					what: "MovePoints-what",
					how: "MovePoints-how",
					note: "MovePoints-note")

				Draw4DHelpItem(
					icon: "Touch Modes/Delete Points",
					what: "DeletePoints-what",
					how: "DeletePoints-how",
					note: nil)

				Draw4DHelpItem(
					icon: "Touch Modes/Delete Edges",
					what: "DeleteEdges-what",
					how: "DeleteEdges-how",
					note: nil)

				Draw4DHelpItem(
					icon: nil,
					what: "RotateScene-what",
					how: "RotateScene-how",
					note: nil)
			}
		}
		.padding(geometryGamesPanelPadding)
		.background(modifiedBackgroundColor)
		.cornerRadius(geometryGamesCornerRadius)
		.frame(width: 320.0, height: 480.0)
	}
}

struct Draw4DHelpItem: View {
	
	let icon: String?
	let what: LocalizedStringKey
	let how: LocalizedStringKey
	let note: LocalizedStringKey?

	var body: some View {

		VStack(alignment: .leading) {

			Text(what)
				.font(.title3)
				.italic()
				.foregroundStyle(helpHowHeaderColor)

			Spacer()
				.frame(height: 4.0)
			
			VStack(alignment: .leading, spacing: 4.0) {
				
				HStack {

					if let theIconName = icon {
						Image(theIconName)
							.padding(8.0)
							.background(.gray)
							.cornerRadius(8.0)
							.padding(EdgeInsets(top: 0.0, leading: 16.0, bottom: 0.0, trailing: 16.0))
					}

					Text(how)
						.font(.body)
				}

				if let theNoteText = note {

					HStack {

						//	Insert a "hidden" copy of the icon,
						//	to provide the correct spacing.
						if let theIconName = icon {
							Image(theIconName)
								.padding(EdgeInsets(top: 0.0, leading: 16.0, bottom: 0.0, trailing: 16.0))
								.hidden()
						}

						Text(theNoteText)
						 .font(.footnote)
						 .foregroundStyle(Color.gray)
					}
				}
			}
			//	Any non-zero top padding (even 0.00001)
			//	causes SwiftUI to insert way too much space.
			//	So let's leave the top padding at 0.0,
			//	and use a Spacer (above) instead.
			.padding(EdgeInsets(top: 0.0, leading: 8.0, bottom: 0.0, trailing: 0.0))
		}
		//	Counterintuitively, .lineLimit(nil) no longer works
		//	to allow multiline Text views, but .fixedSize(…) does.
		//	Note:  SwiftUI's .lineLimit(nil) is deterministic
		//	but inconsistent -- you might have three lines that
		//	get laid out correctly, but then when you add a fourth,
		//	the first line suddenly starts getting truncated.
		.fixedSize(horizontal: false, vertical: true)
	}
}
